
-- Host:                         127.0.0.1
-- Versión del servidor:         PostgreSQL 16.4, compiled by Visual C++ build 1940, 64-bit

-- Volcando estructura para función public.update_conversation_timestamp
DELIMITER //
CREATE FUNCTION "update_conversation_timestamp"() RETURNS UNKNOWN AS $$ 
BEGIN
    UPDATE conversations
    SET updated_at = CURRENT_TIMESTAMP,
        last_interaction_date = CURRENT_TIMESTAMP
    WHERE conversation_id = NEW.conversation_id;
    RETURN NEW;
END;
 $$//
DELIMITER ;

-- Volcando estructura para función public.update_user_last_interaction
DELIMITER //
CREATE FUNCTION "update_user_last_interaction"() RETURNS UNKNOWN AS $$ 
BEGIN
    UPDATE users
    SET last_interaction_date = NEW.timestamp,
        total_interactions = total_interactions + 1
    WHERE phone_number = NEW.phone_number;
    RETURN NEW;
END;
 $$//
DELIMITER ;

-- Volcando estructura para tabla public.conversations
CREATE TABLE IF NOT EXISTS "conversations" (
	"conversation_id" UUID NOT NULL DEFAULT gen_random_uuid(),
	"phone_number" VARCHAR(20) NOT NULL,
	"thread_id" VARCHAR(100) NULL DEFAULT NULL,
	"start_date" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
	"last_interaction_date" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
	"is_active" BOOLEAN NOT NULL DEFAULT true,
	"context_depth" INTEGER NOT NULL DEFAULT 4,
	"created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
	"updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY ("conversation_id"),
	KEY "conversations_phone_number_idx" ("phone_number"),
	CONSTRAINT "conversations_phone_number_fkey" FOREIGN KEY ("phone_number") REFERENCES "users" ("phone_number") ON UPDATE CASCADE ON DELETE RESTRICT
);

-- La exportación de datos fue deseleccionada.

-- Volcando estructura para tabla public.generated_images
CREATE TABLE IF NOT EXISTS "generated_images" (
	"image_id" UUID NOT NULL DEFAULT gen_random_uuid(),
	"message_id" UUID NOT NULL,
	"conversation_id" UUID NOT NULL,
	"prompt_used" TEXT NOT NULL,
	"image_url" TEXT NOT NULL,
	"model_used" VARCHAR(50) NOT NULL DEFAULT 'dall-e-3',
	"image_size" VARCHAR(20) NULL DEFAULT NULL,
	"image_quality" VARCHAR(20) NULL DEFAULT NULL,
	"generation_status" VARCHAR(20) NOT NULL DEFAULT 'completed',
	"created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY ("image_id"),
	KEY "generated_images_conversation_id_idx" ("conversation_id"),
	CONSTRAINT "generated_images_conversation_id_fkey" FOREIGN KEY ("conversation_id") REFERENCES "conversations" ("conversation_id") ON UPDATE CASCADE ON DELETE RESTRICT,
	CONSTRAINT "generated_images_message_id_fkey" FOREIGN KEY ("message_id") REFERENCES "messages" ("message_id") ON UPDATE CASCADE ON DELETE RESTRICT
);

-- La exportación de datos fue deseleccionada.

-- Volcando estructura para tabla public.messages
CREATE TABLE IF NOT EXISTS "messages" (
	"message_id" UUID NOT NULL DEFAULT gen_random_uuid(),
	"conversation_id" UUID NOT NULL,
	"phone_number" VARCHAR(20) NOT NULL,
	"message_type" VARCHAR(10) NOT NULL,
	"content" TEXT NOT NULL,
	"timestamp" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
	"processed_status" VARCHAR(20) NOT NULL DEFAULT 'completed',
	"tokens_used" INTEGER NOT NULL DEFAULT 0,
	"model_used" VARCHAR(50) NULL DEFAULT NULL,
	"completion_tokens" INTEGER NOT NULL DEFAULT 0,
	"prompt_tokens" INTEGER NOT NULL DEFAULT 0,
	"total_tokens" INTEGER NOT NULL DEFAULT 0,
	"response_time" INTEGER NULL DEFAULT NULL,
	"created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
	"file_path" TEXT NULL DEFAULT NULL,
	PRIMARY KEY ("message_id"),
	KEY "messages_conversation_id_idx" ("conversation_id"),
	KEY "messages_phone_number_idx" ("phone_number"),
	KEY "messages_timestamp_idx" ("timestamp"),
	CONSTRAINT "messages_conversation_id_fkey" FOREIGN KEY ("conversation_id") REFERENCES "conversations" ("conversation_id") ON UPDATE CASCADE ON DELETE RESTRICT,
	CONSTRAINT "messages_phone_number_fkey" FOREIGN KEY ("phone_number") REFERENCES "users" ("phone_number") ON UPDATE CASCADE ON DELETE RESTRICT
);

-- La exportación de datos fue deseleccionada.

-- Volcando estructura para tabla public.metrics
CREATE TABLE IF NOT EXISTS "metrics" (
	"metric_id" UUID NOT NULL DEFAULT gen_random_uuid(),
	"conversation_id" UUID NOT NULL,
	"message_id" UUID NOT NULL,
	"api_calls" INTEGER NOT NULL DEFAULT 0,
	"error_count" INTEGER NOT NULL DEFAULT 0,
	"rate_limit_hits" INTEGER NOT NULL DEFAULT 0,
	"cost_estimate" NUMERIC(10,6) NOT NULL DEFAULT 0,
	"performance_score" INTEGER NULL DEFAULT NULL,
	"created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY ("metric_id"),
	CONSTRAINT "metrics_conversation_id_fkey" FOREIGN KEY ("conversation_id") REFERENCES "conversations" ("conversation_id") ON UPDATE CASCADE ON DELETE RESTRICT,
	CONSTRAINT "metrics_message_id_fkey" FOREIGN KEY ("message_id") REFERENCES "messages" ("message_id") ON UPDATE CASCADE ON DELETE RESTRICT
);

-- La exportación de datos fue deseleccionada.

-- Volcando estructura para tabla public.users
CREATE TABLE IF NOT EXISTS "users" (
	"phone_number" VARCHAR(20) NOT NULL,
	"first_interaction_date" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
	"last_interaction_date" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
	"total_interactions" INTEGER NOT NULL DEFAULT 0,
	"preferred_language" VARCHAR(10) NOT NULL DEFAULT 'es',
	"is_active" BOOLEAN NOT NULL DEFAULT true,
	"created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY ("phone_number")
);

-- La exportación de datos fue deseleccionada.


